/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.disk.Drive;
import ags.disk.RWTS;
import java.io.IOException;

public class C6RWTS
extends RWTS {
    public static int BASE = 38;
    public static int ADDR_BUFFER = 38 - BASE;
    public static int ADDR_SECTOR = 61 - BASE;
    public static int ADDR_TRACK = 65 - BASE;
    public static int USE_SLOT = 5;
    public static int USE_DRIVE = 0;

    public C6RWTS() throws IOException {
        super("c6rwts", 162, 32, 160, 0, 162, 3, 134, 60);
    }

    public RWTS.CommandBlock parseCommandBlock(byte[] commandBlock) {
        if (commandBlock.length != ADDR_TRACK + 1) {
            return null;
        }
        int slot = USE_SLOT;
        int drive = USE_DRIVE;
        byte track = commandBlock[ADDR_TRACK];
        byte sector = commandBlock[ADDR_SECTOR];
        int ioBuffAddr = 0xFF & commandBlock[ADDR_BUFFER] | 0xFF00 & commandBlock[ADDR_BUFFER + 1] << 8;
        RWTS.CommandBlock theCommand = new RWTS.CommandBlock(this, this);
        theCommand.setSlot(slot);
        theCommand.setDrive(drive);
        theCommand.setTrack(track);
        theCommand.setSector(this.disk.translatePhysicalSectorNumber(sector));
        theCommand.setBufferAddress(ioBuffAddr);
        theCommand.setVolume(255);
        theCommand.setCommand(RWTS.Command.READ);
        System.out.println("C6 Read: S" + slot + ",D" + drive + ",T" + track + ",S" + sector);
        return theCommand;
    }

    void advance(RWTS.CommandBlock command) {
    }

    void finishRWTS(Drive aThis, RWTS.CommandBlock command) {
    }

    public boolean isLogicalSector() {
        return false;
    }
}

